'use strict';
'require view';
'require dom';
'require poll';
'require rpc';
'require uci';
'require form';
'require network';
'require validation';
var callDHCPLeases = rpc.declare({
    object: 'luci-rpc',
    method: 'getDHCPLeases',
    expect: {
        '': {}
    }
});
return view.extend({
    title: '',
    load: function() {
        return Promise.all([callDHCPLeases(), network.getHostHints()]);
    },
    renderLeases: function(data) {
        var leases = Array.isArray(data[0].dhcp_leases) ? data[0].dhcp_leases : [],
            machints = data[1].getMACHints(false);
        var table = E('div', {
            'class': 'table lases'
        }, [E('div', {
            'class': 'tr table-titles'
        }, [E('div', {
            'class': 'th'
        }, _('Client Name')), E('div', {
            'class': 'th'
        }, _('IPv4-Address')), E('div', {
            'class': 'th'
        }, _('MAC-Address')), E('div', {
            'class': 'th'
        }, _('Lease time remaining'))])]);
        cbi_update_table(table, leases.map(function(lease) {
            var exp;
            if (lease.expires === false)
                exp = E('em', _('unlimited'));
            else if (lease.expires <= 0)
                exp = E('em', _('expired'));
            else
                exp = '%t'.format(lease.expires);
            return [lease.hostname || '-', lease.ipaddr, lease.macaddr, exp];
        }), E('em', _('There are no active leases')));
        return E([E('h3', _('Connected Devices')), table]);
    },
    render: function(data) {
        if (L.hasSystemFeature('dnsmasq') || L.hasSystemFeature('odhcpd'))
            return this.renderLeases(data);
        return E([]);
    },
    handleSaveApply: null,
    handleSave: null,
    handleReset: null
});