'use strict';
'require uci';
'require ui';
'require rpc';
'require view';
'require form';
'require tools.widgets as widgets';
var callInitList, callInitAction, callTimezone, callGetLocaltime, callSetLocaltime, CBILocalTime;
callInitList = rpc.declare({
    object: 'luci',
    method: 'getInitList',
    params: ['name'],
    expect: {
        '': {}
    },
    filter: function(res) {
        for (var k in res)
            return +res[k].enabled;
        return null;
    }
});
callInitAction = rpc.declare({
    object: 'luci',
    method: 'setInitAction',
    params: ['name', 'action'],
    expect: {
        result: false
    }
});
callGetLocaltime = rpc.declare({
    object: 'luci',
    method: 'getLocaltime',
    expect: {
        result: 0
    }
});
callSetLocaltime = rpc.declare({
    object: 'luci',
    method: 'setLocaltime',
    params: ['localtime'],
    expect: {
        result: 0
    }
});
callTimezone = rpc.declare({
    object: 'luci',
    method: 'getTimezones',
    expect: {
        '': {}
    }
});
CBILocalTime = form.DummyValue.extend({
    renderWidget: function(section_id, option_id, cfgvalue) {
        return E([], [E('input', {
            'id': 'localtime',
            'type': 'text',
            'readonly': true,
            'value': new Date(cfgvalue * 1000).toLocaleString()
        }), E('br'), E('span', {
            'class': 'control-group'
        }, [E('button', {
            'class': 'cbi-button cbi-button-apply',
            'click': ui.createHandlerFn(this, function() {
                return callSetLocaltime(Math.floor(Date.now() / 1000));
            }),
            'disabled': (this.readonly != null) ? this.readonly : this.map.readonly
        }, _('Sync with browser')), ' ', this.ntpd_support ? E('button', {
            'class': 'cbi-button cbi-button-apply',
            'click': ui.createHandlerFn(this, function() {
                return callInitAction('sysntpd', 'restart');
            }),
            'disabled': (this.readonly != null) ? this.readonly : this.map.readonly
        }, _('Sync with NTP-Server')) : ''])]);
    },
});

return view.extend({
    load: function() {
        return Promise.all([callInitList('sysntpd'), callTimezone(), callGetLocaltime(), uci.load('luci'), uci.load('system')]);
    },
	render: function(rpc_replies) {
        var ntpd_enabled = rpc_replies[0],
            timezones = rpc_replies[1],
            localtime = rpc_replies[2],
            m, s, o;

        m = new form.Map('system');
        s = m.section(form.TypedSection, "system", _('Language and Style'));
        s.anonymous = true;
        o = s.option(CBILocalTime, '_systime', _('Local Time'));
        o.cfgvalue = function() {
            return localtime
        };
        o.ntpd_support = ntpd_enabled;
        o = s.option(form.ListValue, 'zonename', _('Timezone'));
        o.value('UTC');
        var zones = Object.keys(timezones || {}).sort();
        for (var i = 0; i < zones.length; i++)
            o.value(zones[i]);
        o.write = function(section_id, formvalue) {
            var tz = timezones[formvalue] ? timezones[formvalue].tzstring : null;
            uci.set('system', section_id, 'zonename', formvalue);
            uci.set('system', section_id, 'timezone', tz);
        };
        o = s.option(form.ListValue, '_lang', _('Language'))
        o.uciconfig = 'luci';
        o.ucisection = 'main';
        o.ucioption = 'lang';
        o.value('auto');
        var k = Object.keys(uci.get('luci', 'languages') || {}).sort();
        for (var i = 0; i < k.length; i++)
            if (k[i].charAt(0) != '.')
                o.value(k[i], uci.get('luci', 'languages', k[i]));

		return m.render();
	}
});